; ***********************************************************************************************
;	Macrodefinitionen Stand: 20231016	(c) 2024 by DC7GB unter: BY-NC-SA 4.0
; ***********************************************************************************************


; ACHTUNG: Beim XMEGA werden u.a. andere Namen für SREG, SPH und SPL verwendet. Siehe hierzu:
;          im Pfad: c:\Programme\Atmel\Studio\7.0\packs\atmel\XMEGAA_DFP\1.1.68\avrasm\inc

.macro	pushsr
		push	temp		; Hilfsregister retten
.ifdef	_XMEGA
		in	temp,cpu_sreg	; Statusregister		ACHTUNG: XMega-Name!!!
.else
		in	temp,SREG	; Statusregister retten!
.endif
		push	temp		; ... retten
.endmacro
; --------------------------------------
.macro	popsr
		pop	temp		; Statusregister
.ifdef	_XMEGA
		out	cpu_sreg,temp	; ...zurückladen		ACHTUNG: XMega-Name!!!
.else
		out	SREG,temp	; Statusregister zurückladen
.endif
		pop	temp		; Hilfsregister zurück laden
.endmacro
; --------------------------------------

.MACRO	ADDI
		subi	@0,-(@1)	; Addition einer Konstanten
.ENDMACRO

; --------------------------------------

.MACRO	EXGW
		push	@0H
		push	@0L
		movw	@0,@1
		pop	@1L
		pop	@1H
.ENDMACRO

; --------------------------------------

.MACRO	LDIW
		ldi	@0L,low(@1)
		ldi	@0H,high(@1)
.ENDMACRO

; --------------------------------------

.MACRO	LDSW
		lds	@0L,(@1)
		lds	@0H,(@1)+1
.ENDMACRO

; --------------------------------------

.MACRO	STSW
		sts	(@0),@1L
		sts	(@0)+1,@1H
.ENDMACRO

; --------------------------------------

.MACRO	ADDW
		add	@0L,@1	
		brcc	exit		; kein Überlauf...
		inc	@0H		; Korrektur des H-Bytes
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	CPIW				; ACHTUNG:		nur das Z-Bit abfragen!!!
		cpi	@0H,high(@1)	
		brne	exit		; Konstante <> Wortregister
		cpi	@0L,low(@1)
EXIT:
.ENDMACRO
; --------------------------------------

.MACRO	INCW
		inc	@0L	
		brne	exit		; kein Überlauf
		inc	@0H		; Überlaufkorrektur machen
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	DECW
		dec	@0L	
		brne	exit		; kein Überlauf
		dec	@0H		; Überlaufkorrektur machen
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	INCRAM
		lds	temp,@0		; Byte aus RAM laden
		inc	temp		; ...erhöhen
		sts	@0,temp		; ...und zurück speichern
.ENDMACRO

; --------------------------------------

.MACRO	DECRAM
		lds	temp,@0		; Byte aus RAM laden
		tst	temp		; Zähler schon abgelaufen?
		breq	exit		; ja, nichts ändern
		dec	temp		; Zähler vermindern
		sts	@0,temp		; ...und zurück speichern
EXIT:
.ENDMACRO

; --------------------------------------

.MACRO	CBRAM
		pushsr			; rette Status, mache (temp) frei
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		cbr	temp,@1		;;	lösche Bits
		sts	@0,temp		;;	...und speichere Byte zurück
		popsr			;  ****	EXKLUSIV Ende	
.ENDMACRO

; --------------------------------------

.MACRO	SBRAM
		pushsr			; rette Status, mache (temp) frei
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		sbr	temp,@1		;;	setze Bits
		sts	@0,temp		;;	...und speichere Byte zurück
		popsr			;  ****	EXKLUSIV Ende	
.ENDMACRO

; --------------------------------------

.MACRO	XBRAM
		pushsr			; rette Status, mache (temp) frei
		push	buffer		; Hilfsregister zum Bit-Change
		ldi	buffer,@1	; zu ändernde Bist laden
		cli			;; ****	EXKLUSIV
		lds	temp,@0		;;	Byte aus RAM laden
		eor	temp,buffer	;;	ändere Bits
		sts	@0,temp		;;	...und speichere Byte zurück
		pop	buffer		;;	altes Register restaurieren
		popsr			;  ****	EXKLUSIV Ende	
.ENDMACRO

; --------------------------------------

.MACRO	LDTOS
		pop	@0		; hole Kopie des oberen Stackbytes
		push	@0		; ...und speichere es sofort wieder zurück
.ENDMACRO
